<?php

namespace App\Livewire;

use Livewire\Component;
use Illuminate\Support\Facades\Auth;

class ClientDashboard extends Component
{
    public function render()
    {
        $user = Auth::user();
        $client = $user->clientProfile; // Assumes relationship exists

        // If no client profile, might be a fresh user or admin viewing as client
        $projects = $client ? $client->projects : collect([]);
        $invoices = $client ? $client->invoices : collect([]);

        return view('livewire.client-dashboard', [
            'projects' => $projects,
            'invoices' => $invoices,
            'activeProjectsCount' => $projects->where('status', 'In Progress')->count(),
            'unpaidInvoicesCount' => $invoices->where('status', 'Unpaid')->count(),
        ]);
    }
}
