<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Lead;
use Livewire\WithPagination;

class LeadsBoard extends Component
{
    use WithPagination;

    public $filterStatus = 'all';
    public $search = '';

    public function render()
    {
        $query = Lead::query();

        if ($this->filterStatus !== 'all') {
            $query->where('status', $this->filterStatus);
        }

        if ($this->search) {
            $query->where(function ($q) {
                $q->where('name', 'like', '%' . $this->search . '%')
                    ->orWhere('phone', 'like', '%' . $this->search . '%')
                    ->orWhere('company_name', 'like', '%' . $this->search . '%');
            });
        }

        // Prioritize Hot leads
        $leads = $query->orderBy('lead_score', 'desc')
            ->orderBy('created_at', 'desc')
            ->paginate(10);

        return view('livewire.leads-board', [
            'leads' => $leads,
            'summary' => [
                'total' => Lead::count(),
                'hot' => Lead::where('lead_score', '>=', 50)->count(),
                'new' => Lead::where('status', 'New')->count(),
            ]
        ]);
    }

    public function updateStatus($leadId, $status)
    {
        $lead = Lead::find($leadId);
        if ($lead) {
            $lead->status = $status;
            $lead->save();
            // TODO: Trigger Status Automation
        }
    }
}
