<?php

namespace App\Services;

use App\Models\Lead;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class AutomationService
{
    /**
     * Handle actions when a new lead is created.
     */
    public static function newLead(Lead $lead)
    {
        // 1. Send WhatsApp Welcome
        self::sendWhatsApp($lead->phone, "Hello {$lead->name}, thanks for contacting TechProCode! We will get back to you shortly.");

        // 2. Send Telegram Admin Notification
        self::sendTelegramNotification("🚨 **New Lead Alert**\nName: {$lead->name}\nPhone: {$lead->phone}\nScore: {$lead->lead_score}");

        // 3. Send Email (Placeholder)
        // Mail::to($lead->email)->send(new WelcomeEmail($lead));
    }

    /**
     * Send WhatsApp via Twilio.
     */
    public static function sendWhatsApp($to, $message)
    {
        $sid = env('TWILIO_SID');
        $token = env('TWILIO_TOKEN');
        $from = env('TWILIO_WHATSAPP_NUMBER');

        if (!$sid || !$token) {
            Log::warning("Twilio credentials missing.");
            return;
        }

        try {
            Http::withBasicAuth($sid, $token)
                ->asForm()
                ->post("https://api.twilio.com/2010-04-01/Accounts/$sid/Messages.json", [
                    'From' => "whatsapp:$from",
                    'To' => "whatsapp:$to",
                    'Body' => $message,
                ]);
        } catch (\Exception $e) {
            Log::error("Twilio Error: " . $e->getMessage());
        }
    }

    /**
     * Send Telegram Notification.
     */
    public static function sendTelegramNotification($text)
    {
        $token = env('TELEGRAM_BOT_TOKEN');
        $chatId = env('TELEGRAM_CHAT_ID');

        if (!$token || !$chatId)
            return;

        Http::post("https://api.telegram.org/bot{$token}/sendMessage", [
            'chat_id' => $chatId,
            'text' => $text,
            'parse_mode' => 'Markdown',
        ]);
    }
}
