<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Symfony\Component\Process\Process;

class RunScraper extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'scraper:run {keyword=restaurants} {source=google}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Run the Node.js scraper engine';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $keyword = $this->argument('keyword');
        $this->info("Starting scraper for: $keyword");

        $nodePath = env('SCRAPER_NODE_PATH', 'node');
        $scriptPath = base_path('scraper/scrape.js');

        $process = new Process([$nodePath, $scriptPath, $keyword]);
        $process->setTimeout(300); // 5 minutes

        $process->run(function ($type, $buffer) {
            if (Process::ERR === $type) {
                $this->error($buffer);
            } else {
                $this->line($buffer);
            }
        });

        $this->info('Scraper finished successfully.');
    }
}
