<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Lead extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'company_name',
        'phone',
        'email',
        'country',
        'business_type',
        'source',
        'website',
        'website_quality',
        'status',
        'lead_score',
        'owner_id',
        'last_action',
        'next_followup_date',
        'deal_value',
        'closed_date',
        'lost_reason',
        'notes'
    ];

    protected $casts = [
        'last_action' => 'datetime',
        'next_followup_date' => 'datetime',
        'closed_date' => 'datetime',
        'deal_value' => 'decimal:2',
    ];

    public function owner()
    {
        return $this->belongsTo(User::class, 'owner_id');
    }

    public function client()
    {
        return $this->hasOne(Client::class);
    }

    // Scopes for filtering
    public function scopeHot($query)
    {
        return $query->where('lead_score', '>=', 50);
    }

    public function scopeMyLeads($query, $userId)
    {
        return $query->where('owner_id', $userId);
    }
}
