<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    protected $fillable = [
        'name',
        'email',
        'password',
        'phone',
        'role',
        'is_active',
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
        'is_active' => 'boolean',
    ];

    // Helper methods for roles
    public function isAdmin()
    {
        return $this->role === 'admin';
    }
    public function isCloser()
    {
        return $this->role === 'closer';
    }
    public function isClient()
    {
        return $this->role === 'client';
    }

    // Relationships
    public function clientProfile()
    {
        return $this->hasOne(Client::class);
    }

    public function leads()
    {
        return $this->hasMany(Lead::class, 'owner_id');
    }
}
