<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('leads', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('company_name')->nullable();
            $table->string('phone')->nullable()->index();
            $table->string('email')->nullable();
            $table->string('country')->default('SA');
            $table->string('business_type')->nullable(); // Store, Clinic, Restaurant
            $table->string('source')->default('Manual'); // Landing, LinkedIn, Maps
            $table->string('website')->nullable();
            $table->string('website_quality')->nullable(); // Weak, Good, No Website

            $table->string('status')->default('New'); // New, Contacted, Qualified, Won, Lost
            $table->integer('lead_score')->default(0);

            $table->foreignId('owner_id')->nullable()->constrained('users')->onDelete('set null'); // Closer

            $table->timestamp('last_action')->nullable();
            $table->timestamp('next_followup_date')->nullable();

            $table->decimal('deal_value', 15, 2)->nullable();
            $table->timestamp('closed_date')->nullable();
            $table->text('lost_reason')->nullable();
            $table->text('notes')->nullable();

            $table->softDeletes();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('leads');
    }
};
