<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        // Clients Table (Links to User for login, but contains business info)
        Schema::create('clients', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); // The login user
            $table->foreignId('lead_id')->nullable()->constrained()->onDelete('set null'); // Origin lead
            $table->string('company_name');
            $table->string('status')->default('Active');
            $table->boolean('portal_enabled')->default(true);
            $table->text('notes')->nullable();
            $table->timestamps();
        });

        // Projects Table
        Schema::create('projects', function (Blueprint $table) {
            $table->id();
            $table->foreignId('client_id')->constrained()->onDelete('cascade');
            $table->string('name'); // Project Name
            $table->string('status')->default('In Progress'); // Pending, In Progress, Completed
            $table->string('package')->nullable();
            $table->decimal('propject_value', 15, 2)->default(0);
            $table->date('start_date')->nullable();
            $table->date('due_date')->nullable();
            $table->integer('progress')->default(0); // 0-100
            $table->foreignId('manager_id')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('projects');
        Schema::dropIfExists('clients');
    }
};
