<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="rtl" class="dark">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ config('app.name', 'TechProCode') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Alpine.js -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <style>
        [x-cloak] {
            display: none !important;
        }
    </style>
    @livewireStyles
</head>

<body class="font-sans antialiased bg-gray-900 text-gray-100">

    <div class="min-h-screen flex">
        <!-- Sidebar -->
        <aside class="w-64 bg-gray-800 border-l border-gray-700 hidden md:block">
            <div class="p-6">
                <h2 class="text-2xl font-bold text-blue-500">TechProCode</h2>
            </div>
            <nav class="mt-6 px-4 space-y-2">
                <a href="/dashboard"
                    class="block py-2.5 px-4 rounded transition duration-200 bg-gray-700 text-white hover:bg-gray-700">
                    📊 لوحة القيادة
                </a>
                <a href="/leads"
                    class="block py-2.5 px-4 rounded transition duration-200 hover:bg-gray-700 hover:text-white">
                    👥 العملاء (Leads)
                </a>
                <a href="/projects"
                    class="block py-2.5 px-4 rounded transition duration-200 hover:bg-gray-700 hover:text-white">
                    📁 المشاريع
                </a>
                <a href="/automation"
                    class="block py-2.5 px-4 rounded transition duration-200 hover:bg-gray-700 hover:text-white">
                    ⚙️ الأتمتة
                </a>
            </nav>
        </aside>

        <!-- Main Content -->
        <div class="flex-1 flex flex-col">
            <!-- Header -->
            <header class="bg-gray-800 border-b border-gray-700 p-4 flex justify-between items-center">
                <button class="md:hidden text-gray-400 focus:outline-none">
                    <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M4 6h16M4 12h16M4 18h16" />
                    </svg>
                </button>
                <div class="text-lg font-semibold">
                    {{ $header ?? 'لوحة التحكم' }}
                </div>
                <div class="flex items-center space-x-4 space-x-reverse">
                    <span class="text-sm text-gray-400">مرحباً، {{ auth()->user()->name ?? 'Guest' }}</span>
                </div>
            </header>

            <main class="flex-1 p-6 overflow-y-auto">
                {{ $slot }}
            </main>
        </div>
    </div>

    @livewireScripts
</body>

</html>