<div>
    <x-slot name="header">بوابة العميل — Client Portal</x-slot>

    <!-- Stats -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
        <div class="bg-indigo-900/50 border border-indigo-700 p-6 rounded-xl">
            <h3 class="text-indigo-300 mb-2">المشاريع النشطة</h3>
            <p class="text-4xl font-bold text-white">{{ $activeProjectsCount }}</p>
        </div>
        <div class="bg-red-900/50 border border-red-700 p-6 rounded-xl">
            <h3 class="text-red-300 mb-2">الفواتير المستحقة</h3>
            <p class="text-4xl font-bold text-white">{{ $unpaidInvoicesCount }}</p>
        </div>
    </div>

    <!-- Projects List -->
    <div class="bg-gray-800 rounded-xl border border-gray-700 overflow-hidden mb-8">
        <div class="p-6 border-b border-gray-700">
            <h2 class="text-xl font-bold text-white">مشاريعي</h2>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full text-right text-gray-300">
                <thead class="bg-gray-700/50">
                    <tr>
                        <th class="px-6 py-4">اسم المشروع</th>
                        <th class="px-6 py-4">الحالة</th>
                        <th class="px-6 py-4">الإنجاز</th>
                        <th class="px-6 py-4">تاريخ التسليم</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    @forelse($projects as $project)
                        <tr class="hover:bg-gray-700/30">
                            <td class="px-6 py-4 font-bold text-white">{{ $project->name }}</td>
                            <td class="px-6 py-4">
                                <span
                                    class="px-3 py-1 rounded-full text-xs font-bold 
                                    {{ $project->status == 'Completed' ? 'bg-green-500/20 text-green-400' : 'bg-blue-500/20 text-blue-400' }}">
                                    {{ $project->status }}
                                </span>
                            </td>
                            <td class="px-6 py-4">
                                <div class="w-full bg-gray-700 rounded-full h-2.5">
                                    <div class="bg-blue-600 h-2.5 rounded-full" style="width: {{ $project->progress }}%">
                                    </div>
                                </div>
                                <span class="text-xs mt-1 block">{{ $project->progress }}%</span>
                            </td>
                            <td class="px-6 py-4">{{ $project->due_date ? $project->due_date->format('Y-m-d') : '-' }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="px-6 py-4 text-center text-gray-500">لا توجد مشاريع حالياً</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>