<div>
    <x-slot name="header">إدارة العملاء والـ Leads</x-slot>

    <!-- Stats Cards -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
        <div class="bg-gray-800 p-6 rounded-lg shadow border border-gray-700">
            <h3 class="text-gray-400 text-sm">إجمالي العملاء</h3>
            <p class="text-3xl font-bold text-white">{{ $summary['total'] }}</p>
        </div>
        <div class="bg-gray-800 p-6 rounded-lg shadow border border-gray-700">
            <h3 class="text-gray-400 text-sm">عملاء ساخنين 🔥</h3>
            <p class="text-3xl font-bold text-red-500">{{ $summary['hot'] }}</p>
        </div>
        <div class="bg-gray-800 p-6 rounded-lg shadow border border-gray-700">
            <h3 class="text-gray-400 text-sm">عملاء جدد</h3>
            <p class="text-3xl font-bold text-blue-500">{{ $summary['new'] }}</p>
        </div>
    </div>

    <!-- Filters -->
    <div class="flex flex-col md:flex-row justify-between items-center mb-6 gap-4">
        <input wire:model.live="search" type="text" placeholder="بحث بالاسم أو الهاتف..."
            class="bg-gray-700 text-white px-4 py-2 rounded-lg w-full md:w-1/3 focus:outline-none focus:ring-2 focus:ring-blue-500">

        <select wire:model.live="filterStatus" class="bg-gray-700 text-white px-4 py-2 rounded-lg focus:outline-none">
            <option value="all">كل الحالات</option>
            <option value="New">New</option>
            <option value="Contacted">Contacted</option>
            <option value="Engaged">Engaged</option>
            <option value="Qualified">Qualified</option>
            <option value="Won">Won</option>
            <option value="Lost">Lost</option>
        </select>
    </div>

    <!-- Leads Table -->
    <div class="overflow-x-auto bg-gray-800 rounded-lg shadow border border-gray-700">
        <table class="w-full text-right text-gray-300">
            <thead class="bg-gray-700 text-gray-100 uppercase text-sm">
                <tr>
                    <th class="px-6 py-3">الاسم / الشركة</th>
                    <th class="px-6 py-3">Score</th>
                    <th class="px-6 py-3">المصدر</th>
                    <th class="px-6 py-3">الحالة</th>
                    <th class="px-6 py-3">تاريخ التسجيل</th>
                    <th class="px-6 py-3">إجراءات</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-700">
                @foreach($leads as $lead)
                    <tr class="hover:bg-gray-700/50 transition">
                        <td class="px-6 py-4">
                            <div class="font-bold text-white">{{ $lead->name }}</div>
                            <div class="text-sm text-gray-400">{{ $lead->company_name ?? 'شخصي' }}</div>
                            <div class="text-xs text-blue-400">{{ $lead->phone }}</div>
                        </td>
                        <td class="px-6 py-4">
                            <span
                                class="px-2 py-1 rounded bg-gray-700 font-bold {{ $lead->lead_score >= 50 ? 'text-red-400' : 'text-green-400' }}">
                                {{ $lead->lead_score }}
                            </span>
                        </td>
                        <td class="px-6 py-4">{{ $lead->source }}</td>
                        <td class="px-6 py-4">
                            <select wire:change="updateStatus({{ $lead->id }}, $event.target.value)"
                                class="bg-gray-900 border border-gray-600 rounded px-2 py-1 text-sm focus:outline-none cursor-pointer">
                                <option value="New" {{ $lead->status == 'New' ? 'selected' : '' }}>New</option>
                                <option value="Contacted" {{ $lead->status == 'Contacted' ? 'selected' : '' }}>Contacted
                                </option>
                                <option value="Qualified" {{ $lead->status == 'Qualified' ? 'selected' : '' }}>Qualified
                                </option>
                                <option value="Won" {{ $lead->status == 'Won' ? 'selected' : '' }}>Won</option>
                                <option value="Lost" {{ $lead->status == 'Lost' ? 'selected' : '' }}>Lost</option>
                            </select>
                        </td>
                        <td class="px-6 py-4 text-sm">{{ $lead->created_at->diffForHumans() }}</td>
                        <td class="px-6 py-4">
                            <button class="text-blue-400 hover:text-blue-300">تفاصيل</button>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <div class="mt-4">
        {{ $leads->links() }}
    </div>
</div>