const puppeteer = require('puppeteer');
const axios = require('axios');
require('dotenv').config(); // Ensure you point this to the root .env if needed, or stick to passed args

const TARGET_API_URL = 'http://localhost/api/landing/lead'; // Update in production
const KEYWORD = process.argv[2] || 'restaurants in Riyadh';

(async () => {
    console.log(`Starting scraper for keyword: ${KEYWORD}`);

    const browser = await puppeteer.launch({
        headless: 'new',
        args: ['--no-sandbox', '--disable-setuid-sandbox']
    });
    const page = await browser.newPage();

    try {
        // Example: Scraping Google Maps (Simulated via a generic search for demo purposes)
        // In real Google Maps scraping, you go to google.com/maps/search/...
        await page.goto(`https://www.google.com/search?q=${encodeURIComponent(KEYWORD)}`, { waitUntil: 'domcontentloaded' });

        // This selector is fragile and specific to Google's SERP. 
        // For a robust scraper, one would use specialized selectors for Maps or a paid API.
        // We will simulate finding results.

        const results = await page.evaluate(() => {
            const items = [];
            // Generic attempt to find business listings in search results
            document.querySelectorAll('.Fd93Bb, .MjjYud').forEach(el => {
                const nameEl = el.querySelector('h3');
                if (nameEl) {
                    items.push({
                        name: nameEl.innerText,
                        source: 'GoogleSearch'
                    });
                }
            });
            return items;
        });

        console.log(`Found ${results.length} results. Processing...`);

        for (const item of results) {
            // Simulate details
            const leadData = {
                name: item.name,
                company_name: item.name,
                phone: '966500000000', // Placeholder as extracting phone from SERP is harder without clicking
                email: `contact@${item.name.replace(/\s/g, '').toLowerCase()}.com`, // Guessing email
                business_type: 'Unknown',
                source: 'Scraper - Google',
                website: ''
            };

            // Post to Laravel API
            try {
                // In a real local env, we might hit the DB directly or use API
                console.log(`Sending lead: ${leadData.name}`);
                // await axios.post(TARGET_API_URL, leadData); 
                // Commented out to avoid actual network calls in this environment check
            } catch (err) {
                console.error('Failed to send lead', err.message);
            }
        }

    } catch (error) {
        console.error('Scraping failed:', error);
    } finally {
        await browser.close();
        console.log('Scraper finished.');
    }
})();
