<!DOCTYPE html>
<html lang="ar" dir="rtl" class="scroll-smooth">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TechProCode | Automated Sales System</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@300;400;700;900&display=swap" rel="stylesheet">
    <script src="//unpkg.com/alpinejs" defer></script>
    <style>
        body {
            font-family: 'Tajawal', sans-serif;
        }

        .glass {
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .gradient-text {
            background-clip: text;
            -webkit-background-clip: text;
            color: transparent;
            background-image: linear-gradient(to right, #4ade80, #3b82f6);
        }
    </style>
</head>

<body class="bg-[#0f172a] text-white overflow-x-hidden">

    <!-- Navbar -->
    <nav class="fixed w-full z-50 glass bg-opacity-80 transition-all duration-300">
        <div class="max-w-7xl mx-auto px-4 py-4 flex justify-between items-center">
            <h1 class="text-2xl font-black gradient-text">TechProCode</h1>
            <div class="hidden md:flex space-x-6 space-x-reverse">
                <a href="#services" class="hover:text-blue-400 transition">الخدمات</a>
                <a href="#results" class="hover:text-blue-400 transition">النتائج</a>
                <a href="#pricing" class="hover:text-blue-400 transition">الباقات</a>
            </div>
            <a href="#contact"
                class="bg-blue-600 hover:bg-blue-700 px-6 py-2 rounded-full font-bold transition shadow-lg shadow-blue-500/30">ابدأ
                الآن</a>
        </div>
    </nav>

    <!-- Hero Section -->
    <header class="relative pt-32 pb-20 overflow-hidden">
        <div
            class="absolute top-0 left-0 w-full h-full opacity-20 bg-[url('https://cdn.pixabay.com/photo/2018/03/10/12/00/teamwork-3213924_1280.jpg')] bg-cover bg-center">
        </div>
        <div class="max-w-7xl mx-auto px-4 text-center relative z-10">
            <h1 class="text-5xl md:text-7xl font-black mb-6 leading-tight">
                حول عملك إلى آلة مبيعات <br><span class="gradient-text">تعمل تلقائيًا 24/7</span>
            </h1>
            <p class="text-xl md:text-2xl text-gray-300 mb-10 max-w-3xl mx-auto">
                نظام متكامل لجلب العملاء، إدارة المبيعات، ومتابعة المشاريع. كل ما تحتاجه لتوسيع أعمالك في مكان واحد.
            </p>
            <div class="flex flex-col md:flex-row justify-center gap-4">
                <a href="#contact"
                    class="bg-gradient-to-r from-blue-600 to-indigo-600 hover:from-blue-700 hover:to-indigo-700 px-8 py-4 rounded-xl font-bold text-xl transition transform hover:scale-105 shadow-xl">احصل
                    على استشارة مجانية</a>
                <a href="#services"
                    class="glass hover:bg-white/10 px-8 py-4 rounded-xl font-bold text-xl transition">اكتشف المزيد</a>
            </div>
        </div>
    </header>

    <!-- Services Section -->
    <section id="services" class="py-20 bg-[#1e293b]">
        <div class="max-w-7xl mx-auto px-4">
            <h2 class="text-3xl md:text-5xl font-bold text-center mb-16"><span class="text-blue-500">خدماتنا</span>
                الاحترافية</h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- Service 1 -->
                <div class="glass p-8 rounded-2xl hover:bg-white/5 transition duration-300">
                    <div class="w-16 h-16 bg-blue-500/20 rounded-lg flex items-center justify-center mb-6 text-3xl">🚀
                    </div>
                    <h3 class="text-2xl font-bold mb-4">أتمتة المبيعات</h3>
                    <p class="text-gray-400">نظام CRM ذكي يتابع عملائك تلقائيًا عبر الواتساب والإيميل لزيادة نسبة
                        الإغلاق.</p>
                </div>
                <!-- Service 2 -->
                <div class="glass p-8 rounded-2xl hover:bg-white/5 transition duration-300">
                    <div class="w-16 h-16 bg-green-500/20 rounded-lg flex items-center justify-center mb-6 text-3xl">🕷️
                    </div>
                    <h3 class="text-2xl font-bold mb-4">محرك جلب العملاء</h3>
                    <p class="text-gray-400">استخراج بيانات العملاء المحتملين من خرائط جوجل ولينكد إن بدقة عالية.</p>
                </div>
                <!-- Service 3 -->
                <div class="glass p-8 rounded-2xl hover:bg-white/5 transition duration-300">
                    <div class="w-16 h-16 bg-purple-500/20 rounded-lg flex items-center justify-center mb-6 text-3xl">💼
                    </div>
                    <h3 class="text-2xl font-bold mb-4">بوابة العملاء</h3>
                    <p class="text-gray-400">لوحة تحكم احترافية لعملائك لمتابعة مشاريعهم وفواتيرهم بكل شفافية.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Lead Form Section -->
    <section id="contact" class="py-20 relative">
        <div class="max-w-4xl mx-auto px-4">
            <div class="glass rounded-3xl p-10 md:p-16 relative overflow-hidden">
                <div class="absolute top-0 right-0 w-64 h-64 bg-blue-600/20 blur-3xl rounded-full -mr-20 -mt-20"></div>
                <div class="absolute bottom-0 left-0 w-64 h-64 bg-purple-600/20 blur-3xl rounded-full -ml-20 -mb-20">
                </div>

                <h2 class="text-3xl md:text-4xl font-bold text-center mb-8 relative z-10">جاهز لتغيير مسار عملك؟</h2>
                <p class="text-center text-gray-400 mb-10 relative z-10">املأ النموذج وسنقوم بالتواصل معك فورًا.</p>

                <form x-data="leadForm()" @submit.prevent="submitForm" class="space-y-6 relative z-10">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-medium text-gray-400 mb-2">الاسم الكامل</label>
                            <input type="text" x-model="formData.name" required
                                class="w-full bg-[#0f172a] border border-gray-700 rounded-lg px-4 py-3 focus:outline-none focus:border-blue-500 transition text-white">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-400 mb-2">رقم الهاتف (واتساب)</label>
                            <input type="tel" x-model="formData.phone" required
                                class="w-full bg-[#0f172a] border border-gray-700 rounded-lg px-4 py-3 focus:outline-none focus:border-blue-500 transition text-white"
                                placeholder="9665xxxxxxxx">
                        </div>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-400 mb-2">البريد الإلكتروني</label>
                        <input type="email" x-model="formData.email" required
                            class="w-full bg-[#0f172a] border border-gray-700 rounded-lg px-4 py-3 focus:outline-none focus:border-blue-500 transition text-white">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-400 mb-2">اسم الشركة (اختياري)</label>
                        <input type="text" x-model="formData.company_name"
                            class="w-full bg-[#0f172a] border border-gray-700 rounded-lg px-4 py-3 focus:outline-none focus:border-blue-500 transition text-white">
                    </div>

                    <button type="submit" :disabled="loading"
                        class="w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-4 rounded-xl transition shadow-lg shadow-blue-500/30 flex justify-center items-center">
                        <span x-show="!loading">أرسل الطلب الآن</span>
                        <svg x-show="loading" class="animate-spin h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg"
                            fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4">
                            </circle>
                            <path class="opacity-75" fill="currentColor"
                                d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z">
                            </path>
                        </svg>
                    </button>

                    <div x-show="success" class="mt-4 p-4 bg-green-500/20 text-green-400 rounded-lg text-center"
                        style="display: none;">
                        تم استلام طلبك بنجاح! سنتواصل معك قريبًا.
                    </div>
                    <div x-show="error" class="mt-4 p-4 bg-red-500/20 text-red-400 rounded-lg text-center"
                        style="display: none;">
                        حصل خطأ ما، الرجاء المحاولة مرة أخرى.
                    </div>
                </form>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-[#0b1120] py-10 text-center text-gray-500 text-sm">
        <p>&copy; 2025 TechProCode. جميع الحقوق محفوظة.</p>
    </footer>

    <script>
        function leadForm() {
            return {
                formData: {
                    name: '',
                    phone: '',
                    email: '',
                    company_name: ''
                },
                loading: false,
                success: false,
                error: false,
                submitForm() {
                    this.loading = true;
                    this.success = false;
                    this.error = false;

                    fetch('/api/landing/lead', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'Accept': 'application/json'
                        },
                        body: JSON.stringify(this.formData)
                    })
                        .then(response => {
                            if (response.ok) {
                                this.success = true;
                                this.formData = { name: '', phone: '', email: '', company_name: '' };
                            } else {
                                this.error = true;
                            }
                        })
                        .catch(() => {
                            this.error = true;
                        })
                        .finally(() => {
                            this.loading = false;
                        });
                }
            }
        }
    </script>
</body>

</html><?php /**PATH D:\ai\n8n\resources\views/landing.blade.php ENDPATH**/ ?>